/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Last Modification:
    @version $Id: S3M_SVC_Public.h 37032 2013-08-02 12:20:52Z Sven $

   Description:

    SERCOSIIIMaster SVC
    public

   Changes:

     Date        Author    Description
     ----------------------------------------------------------------------------------
     09.10.2008  UJ        initial version
     04.10.2009  UJ        MACRO_READ_COMMAND_STATUS-Packet fixed structure
                           calculated now correct: SIII_MA_SVC_*_MAX_PACKET_STEPS,
                           removed PACKED where it was not necessary in structures
     05.03.2009  UJ        cleanups
     05.02.2009  UJ        added PACKED again to avoid length problems
     19.03.2009  UJ        added usSlaveAddr for remaining confirmation packets
                           SIII_MA_SVC_ATOMIC_WRITE_REQ_MIN_SIZE removed,
                           use SIII_MA_SVC_ATOMIC_WRITE_REQ_EMPTY_SIZE instead
                           removed SIII_MA_SVC_ATOMIC_WRITE_CNF_EMPTY_SIZE and SIII_MA_SVC_ATOMIC_GET_LL_CNF_EMPTY_SIZE
                           moved ATOMIC_POLL_STATUS to Private Header (not public any more!)
                           renamed usLength to usTotalLength to avoid confusion
     28.04.2009  UJ        changed postion of __PACKED_POST to avoid trouble with GCC < 4.0

     2012-05-11  SB        extracted internal CP->SVC task packets into own header

**************************************************************************************/

#ifndef __S3M_SVC_PUBLIC_H
#define __S3M_SVC_PUBLIC_H


#define  SIII_MA_SVC_CMD_ATOMIC_READ_REQ                0x00004902
#define  SIII_MA_SVC_CMD_ATOMIC_READ_CNF                0x00004903

#define  SIII_MA_SVC_CMD_ATOMIC_WRITE_REQ               0x00004904
#define  SIII_MA_SVC_CMD_ATOMIC_WRITE_CNF               0x00004905

#define  SIII_MA_SVC_CMD_ATOMIC_GET_LL_REQ              0x00004906
#define  SIII_MA_SVC_CMD_ATOMIC_GET_LL_CNF              0x00004907

#define  SIII_MA_SVC_CMD_MACRO_READ_REQ                 0x00004908
#define  SIII_MA_SVC_CMD_MACRO_READ_CNF                 0x00004909

#define  SIII_MA_SVC_CMD_MACRO_WRITE_REQ                0x0000490A
#define  SIII_MA_SVC_CMD_MACRO_WRITE_CNF                0x0000490B

#define  SIII_MA_SVC_CMD_MACRO_SET_COMMAND_REQ          0x0000490C
#define  SIII_MA_SVC_CMD_MACRO_SET_COMMAND_CNF          0x0000490D

#define  SIII_MA_SVC_CMD_MACRO_CLEAR_COMMAND_REQ        0x0000490E
#define  SIII_MA_SVC_CMD_MACRO_CLEAR_COMMAND_CNF        0x0000490F

#define  SIII_MA_SVC_CMD_MACRO_READ_COMMAND_STATUS_REQ  0x00004910
#define  SIII_MA_SVC_CMD_MACRO_READ_COMMAND_STATUS_CNF  0x00004911

#define  SIII_MA_SVC_CMD_ABORT_ATOMIC_TRANSFER_REQ      0x0000491E
#define  SIII_MA_SVC_CMD_ABORT_ATOMIC_TRANSFER_CNF      0x0000491F

#define  SIII_MA_SVC_CMD_ABORT_MACRO_TRANSFER_REQ       0x00004920
#define  SIII_MA_SVC_CMD_ABORT_MACRO_TRANSFER_CNF       0x00004921


#define  SIII_MA_SVC_CMD_ATOMIC_READ_EXT_REQ            0x00004940
#define  SIII_MA_SVC_CMD_ATOMIC_READ_EXT_CNF            0x00004941

#define  SIII_MA_SVC_CMD_ATOMIC_WRITE_EXT_REQ           0x00004942
#define  SIII_MA_SVC_CMD_ATOMIC_WRITE_EXT_CNF           0x00004943

#define  SIII_MA_SVC_CMD_MACRO_READ_EXT_REQ             0x00004944
#define  SIII_MA_SVC_CMD_MACRO_READ_EXT_CNF             0x00004945

#define  SIII_MA_SVC_CMD_MACRO_WRITE_EXT_REQ            0x00004946
#define  SIII_MA_SVC_CMD_MACRO_WRITE_EXT_CNF            0x00004947

/* 0x49C0-0x49FF reserved */

/** queue name */
#define SERCOSIIIMASTER_SVC_QUEUE_NAME        "QUE_S3M_SVC"


/******************************************************************************
 * SvchError Codes
 */
/* bus-side error codes */
enum SIII_MA_SVC_SVCH_ERROR_Etag
{
  SIII_MA_SVC_SVCH_ERROR_NO_ERROR                                           = 0x0000,
  SIII_MA_SVC_SVCH_ERROR_SERVICE_CHANNEL_NOT_OPEN                           = 0x0001,
  SIII_MA_SVC_SVCH_ERROR_INVALID_ACCESS_TO_CLOSING_SVC                      = 0x0009,

  SIII_MA_SVC_SVCH_ERROR_NO_IDN                                             = 0x1001,
  SIII_MA_SVC_SVCH_ERROR_INVALID_ACCESS_TO_ELEMENT_ONE                      = 0x1009,

  SIII_MA_SVC_SVCH_ERROR_NO_NAME                                            = 0x2001,
  SIII_MA_SVC_SVCH_ERROR_NAME_TRANSMISSION_TOO_SHORT                        = 0x2002,
  SIII_MA_SVC_SVCH_ERROR_NAME_TRANSMISSION_TOO_LONG                         = 0x2003,
  SIII_MA_SVC_SVCH_ERROR_NAME_CANNOT_BE_CHANGED_READ_ONLY                   = 0x2004,
  SIII_MA_SVC_SVCH_ERROR_NAME_IS_WRITE_PROTECTED_AT_THIS_TIME               = 0x2005,

  SIII_MA_SVC_SVCH_ERROR_ATTRIBUTE_TRANSMISSION_TOO_SHORT                   = 0x3002,
  SIII_MA_SVC_SVCH_ERROR_ATTRIBUTE_TRANSMISSION_TOO_LONG                    = 0x3003,
  SIII_MA_SVC_SVCH_ERROR_ATTRIBUTE_CANNOT_BE_CHANGED_READ_ONLY              = 0x3004,
  SIII_MA_SVC_SVCH_ERROR_ATTRIBUTE_IS_WRITE_PROTECTED_AT_THIS_TIME          = 0x3005,

  SIII_MA_SVC_SVCH_ERROR_NO_UNIT                                            = 0x4001,
  SIII_MA_SVC_SVCH_ERROR_UNIT_TRANSMISSION_TOO_SHORT                        = 0x4002,
  SIII_MA_SVC_SVCH_ERROR_UNIT_TRANSMISSION_TOO_LONG                         = 0x4003,
  SIII_MA_SVC_SVCH_ERROR_UNIT_CANNOT_BE_CHANGED_READ_ONLY                   = 0x4004,

  SIII_MA_SVC_SVCH_ERROR_NO_MINIMUM_VALUE                                   = 0x5001,
  SIII_MA_SVC_SVCH_ERROR_MINIMUM_VALUE_TRANSMISSION_TOO_SHORT               = 0x5002,
  SIII_MA_SVC_SVCH_ERROR_MINIMUM_VALUE_TRANSMISSION_TOO_LONG                = 0x5003,
  SIII_MA_SVC_SVCH_ERROR_MINIMUM_VALUE_CANNOT_BE_CHANGED_READ_ONLY          = 0x5004,
  SIII_MA_SVC_SVCH_ERROR_MINIMUM_VALUE_IS_WRITE_PROTECTED_AT_THIS_TIME      = 0x5005,

  SIII_MA_SVC_SVCH_ERROR_NO_MAXIMUM_VALUE                                   = 0x6001,
  SIII_MA_SVC_SVCH_ERROR_MAXIMUM_VALUE_TRANSMISSION_TOO_SHORT               = 0x6002,
  SIII_MA_SVC_SVCH_ERROR_MAXIMUM_VALUE_TRANSMISSION_TOO_LONG                = 0x6003,
  SIII_MA_SVC_SVCH_ERROR_MAXIMUM_VALUE_CANNOT_BE_CHANGED_READ_ONLY          = 0x6004,
  SIII_MA_SVC_SVCH_ERROR_MAXIMUM_VALUE_IS_WRITE_PROTECTED_AT_THIS_TIME      = 0x6005,

  SIII_MA_SVC_SVCH_ERROR_OPDATA_TRANSMISSION_TOO_SHORT                      = 0x7002,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_TRANSMISSION_TOO_LONG                       = 0x7003,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_CANNOT_BE_CHANGED_READ_ONLY                 = 0x7004,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_IS_WRITE_PROTECTED_AT_THIS_TIME             = 0x7005,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_IS_SMALLER_THAN_THE_MINIMUM_VALUE           = 0x7006,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_IS_GREATER_THAN_THE_MAXIMUM_VALUE           = 0x7007,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_INVALID                                     = 0x7008,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_IS_WRITE_PROTECTED_BY_PASSWORD              = 0x7009,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_WRITE_PROTECTED_CONFIGURED_CYCLICALLY       = 0x700A,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_INVALID_INDIRECT_ADDRESSING                 = 0x700B,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_WRITE_PROTECTED_DUE_OTHER_SETTINGS          = 0x700C,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_INVALID_FLOATING_POINT_NUMBER               = 0x700D,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_WRITE_PROTECTED_AT_PARAMETERIZATION_LEVEL   = 0x700E,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_WRITE_PROTECTED_AT_OPERATING_LEVEL          = 0x700F,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_PROCEDURE_COMMAND_ALREADY_ACTIVE            = 0x7010,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_PROCEDURE_COMMAND_NOT_INTERRUPTIBLE         = 0x7011,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_PROCEDURE_COMMAND_NOT_EXEC_AT_THIS_TIME     = 0x7012,
  SIII_MA_SVC_SVCH_ERROR_OPDATA_PROCEDURE_COMMAND_NOT_EXECUTABLE            = 0x7013  /* invalid parameter etc. */
};

enum SIII_MA_SVC_DBE_Etag
{
  SIII_MA_SVC_DBE_CLOSE_IDN         = 0,
  SIII_MA_SVC_DBE_DATA_STATUS       = 1, /* OpenIDN */
  SIII_MA_SVC_DBE_NAME              = 2,
  SIII_MA_SVC_DBE_ATTRIBUTE         = 3,
  SIII_MA_SVC_DBE_UNIT              = 4,
  SIII_MA_SVC_DBE_MINIMUM_VALUE     = 5,
  SIII_MA_SVC_DBE_MAXIMUM_VALUE     = 6,
  SIII_MA_SVC_DBE_OPDATA            = 7
};

/*-------------------------------------*/
/* Parameter definitions for macro services */

/* usPriority */
enum SIII_MA_SVC_MACRO_PRIORITY_Etag
{
  SIII_MA_SVC_MACRO_PRIORITY_LOW                  = 0,
  SIII_MA_SVC_MACRO_PRIORITY_HIGH                 = 1
};

/* usIsList */
enum SIII_MA_SVC_MACRO_IS_LIST_Etag
{
  SIII_MA_SVC_MACRO_NOT_A_LIST                    = 0,
  SIII_MA_SVC_MACRO_IS_LIST                       = 1,
  SIII_MA_SVC_MACRO_IS_LIST_READ_LISTLENGTH_ONLY  = 2,
  SIII_MA_SVC_MACRO_NO_LIST_INFORMATION           = 3
};

/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__S3M_SVC_PACKET)
#endif

/******************************************************************************
 * Packet: SIII_MA_SVC_CMD_ATOMIC_READ_REQ/SIII_MA_SVC_CMD_ATOMIC_READ_CNF
 */
/* note: SVC-Steps are 4 byte each */
#define SIII_MA_SVC_ATOMIC_READ_MAX_PACKET_STEPS (384)
/* variant of macro to have the actual number of bytes per read */
#define SIII_MA_SVC_ATOMIC_READ_MAX_DATA_BYTES (SIII_MA_SVC_ATOMIC_READ_MAX_PACKET_STEPS * 4)

/********** request packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_READ_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;   /* Slave address */
  TLR_UINT16 usElem;        /* getDataStatus-1; getName-2; getAttribute-3; getUnit-4; getMin-5; getMax-6; getData-7; */
  TLR_UINT16 usTotalLength; /* total number of bytes to read (if list, including 4 byte header) */
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_READ_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_READ_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  SIII_MA_SVC_ATOMIC_READ_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_READ_REQ_T;


/********** confirmation packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_READ_CNF_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;  /* Slave address */
  TLR_UINT16 usSvchError;  /* SVC-Error reported from slave (see SERCOS-Spec) */
#ifdef __SIII_MA_SVC_LEGACY_PACKET_STRUCTURE__
  TLR_UINT16 ausData[SIII_MA_SVC_ATOMIC_READ_MAX_PACKET_STEPS * 2]; /* holds data: Name on GetName(), Attribute on GetAttribute(), Unit on GetUnit(), Min on GetMin(), Max on GetMax() */
#else
  TLR_UINT8  abData[SIII_MA_SVC_ATOMIC_READ_MAX_PACKET_STEPS * 4]; /* holds data: Name on GetName(), Attribute on GetAttribute(), Unit on GetUnit(), Min on GetMin(), Max on GetMax() */
#endif
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_READ_CNF_DATA_T;

#define SIII_MA_SVC_ATOMIC_READ_CNF_EMPTY_SIZE ( 2*sizeof (TLR_UINT16))

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_READ_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  SIII_MA_SVC_ATOMIC_READ_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_READ_CNF_T;


/********** packet union **********/
typedef union SIII_MA_SVC_ATOMIC_READ_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_SVC_ATOMIC_READ_REQ_T   tReq;
  SIII_MA_SVC_ATOMIC_READ_CNF_T   tCnf;
} SIII_MA_SVC_ATOMIC_READ_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_SVC_CMD_ATOMIC_READ_EXT_REQ/SIII_MA_SVC_CMD_ATOMIC_READ_EXT_CNF
 */

/********** request packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_READ_EXT_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;   /* Slave address */
  TLR_UINT16 usElem;        /* getDataStatus-1; getName-2; getAttribute-3; getUnit-4; getMin-5; getMax-6; getData-7; */
  TLR_UINT32 ulTotalLength; /* total number of bytes to read (if list, including 4 byte header) */
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_READ_EXT_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_EXT_READ_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_MA_SVC_ATOMIC_READ_EXT_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_READ_EXT_REQ_T;


/********** confirmation packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_READ_EXT_CNF_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;  /* Slave address */
  TLR_UINT16 usSvchError;  /* SVC-Error reported from slave (see SERCOS-Spec) */
  TLR_UINT8  abData[SIII_MA_SVC_ATOMIC_READ_MAX_PACKET_STEPS * 4]; /* holds data: Name on GetName(), Attribute on GetAttribute(), Unit on GetUnit(), Min on GetMin(), Max on GetMax() */
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_READ_EXT_CNF_DATA_T;

#define SIII_MA_SVC_ATOMIC_READ_EXT_CNF_EMPTY_SIZE ( 2*sizeof (TLR_UINT16))

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_READ_EXT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_MA_SVC_ATOMIC_READ_EXT_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_READ_EXT_CNF_T;


/********** packet union **********/
typedef union SIII_MA_SVC_ATOMIC_READ_EXT_PCK_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  SIII_MA_SVC_ATOMIC_READ_EXT_REQ_T tReq;
  SIII_MA_SVC_ATOMIC_READ_EXT_CNF_T tCnf;
} SIII_MA_SVC_ATOMIC_READ_EXT_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_SVC_CMD_ATOMIC_WRITE_REQ/SIII_MA_SVC_CMD_ATOMIC_WRITE_CNF
 */

/* note: SVC-Steps are 4 byte each */
#define SIII_MA_SVC_ATOMIC_WRITE_MAX_PACKET_STEPS (384)
/* variant of macro to have the actual number of bytes per write */
#define SIII_MA_SVC_ATOMIC_WRITE_MAX_DATA_BYTES (SIII_MA_SVC_ATOMIC_WRITE_MAX_PACKET_STEPS * 4)

/********** request packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_WRITE_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;   /* Slave address */
  TLR_UINT16 usElem;        /* closeIDN-0; openIDN-1; putData-7 */
  TLR_UINT16 usTotalLength; /* total number of bytes to read or write (if list, including 4 byte header) */
  /* concept: usTotalLength is only evaluated, if PutData() and Sequence != NONE */
#ifdef __SIII_MA_SVC_LEGACY_PACKET_STRUCTURE__
  TLR_UINT16 ausData[SIII_MA_SVC_ATOMIC_WRITE_MAX_PACKET_STEPS*2]; /* OpenIdn() the new IDN is stored in the first 4 byte
                               putData() if a list is written, the list header is included here */
#else
  TLR_UINT8  abData[SIII_MA_SVC_ATOMIC_WRITE_MAX_PACKET_STEPS*4]; /* OpenIdn() the new IDN is stored in the first 4 byte
                               putData() if a list is written, the list header is included here */
#endif
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_WRITE_REQ_DATA_T;

/* request without data payload */
#define SIII_MA_SVC_ATOMIC_WRITE_REQ_EMPTY_SIZE ( 3*sizeof (TLR_UINT16))

/* open IDN needs usSlaveAddr + usElem + usTotalLength + IDN (4 Byte) */
#define SIII_MA_SVC_ATOMIC_WRITE_REQ_OPEN_IDN_SIZE ( 3*sizeof (TLR_UINT16) + sizeof(TLR_UINT32) )

/* close IDN needs usSlaveAddr + usElem + usTotalLength */
#define SIII_MA_SVC_ATOMIC_WRITE_REQ_CLOSE_IDN_SIZE ( 3*sizeof (TLR_UINT16))

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_WRITE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                  tHead;
  SIII_MA_SVC_ATOMIC_WRITE_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_WRITE_REQ_T;


/********** confirmation packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_WRITE_CNF_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;  /* Slave address */
  TLR_UINT16 usSvchError;  /* SVC-Error reported from slave (see SERCOS-Spec) */
  TLR_UINT16 usDataStatus; /* only used if usElem was OpenIdn(1) */
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_WRITE_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_WRITE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                  tHead;
  SIII_MA_SVC_ATOMIC_WRITE_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_WRITE_CNF_T;


/********** packet union **********/
typedef union SIII_MA_SVC_ATOMIC_WRITE_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_SVC_ATOMIC_WRITE_REQ_T  tReq;
  SIII_MA_SVC_ATOMIC_WRITE_CNF_T  tCnf;
} SIII_MA_SVC_ATOMIC_WRITE_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_SVC_CMD_ATOMIC_WRITE_EXT_REQ/SIII_MA_SVC_CMD_ATOMIC_WRITE_EXT_CNF
 */


/********** request packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_WRITE_EXT_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;   /* Slave address */
  TLR_UINT16 usElem;        /* closeIDN-0; openIDN-1; putData-7 */
  TLR_UINT32 ulTotalLength; /* total number of bytes to read or write (if list, including 4 byte header) */
  /* concept: usTotalLength is only evaluated, if PutData() and Sequence != NONE */
  TLR_UINT8  abData[SIII_MA_SVC_ATOMIC_WRITE_MAX_PACKET_STEPS*4]; /* OpenIdn() the new IDN is stored in the first 4 byte
                               putData() if a list is written, the list header is included here */
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_WRITE_EXT_REQ_DATA_T;

/* request without data payload */
#define SIII_MA_SVC_ATOMIC_WRITE_EXT_REQ_EMPTY_SIZE ( 2*sizeof (TLR_UINT16) + sizeof(TLR_UINT32))

/* open IDN needs usSlaveAddr + usElem + usTotalLength + IDN (4 Byte) */
#define SIII_MA_SVC_ATOMIC_WRITE_EXT_REQ_OPEN_IDN_SIZE ( 2*sizeof (TLR_UINT16) + 2*sizeof(TLR_UINT32) )

/* close IDN needs usSlaveAddr + usElem + usTotalLength */
#define SIII_MA_SVC_ATOMIC_WRITE_EXT_REQ_CLOSE_IDN_SIZE ( 2*sizeof (TLR_UINT16) + sizeof(TLR_UINT32))

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_WRITE_EXT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_MA_SVC_ATOMIC_WRITE_EXT_REQ_DATA_T tData;
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_WRITE_EXT_REQ_T;


/********** confirmation packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_WRITE_EXT_CNF_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;  /* Slave address */
  TLR_UINT16 usSvchError;  /* SVC-Error reported from slave (see SERCOS-Spec) */
  TLR_UINT16 usDataStatus; /* only used if usElem was OpenIdn(1) */
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_WRITE_EXT_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_WRITE_EXT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_MA_SVC_ATOMIC_WRITE_EXT_CNF_DATA_T tData;
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_WRITE_EXT_CNF_T;


/********** packet union **********/
typedef union SIII_MA_SVC_ATOMIC_WRITE_EXT_PCK_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  SIII_MA_SVC_ATOMIC_WRITE_EXT_REQ_T  tReq;
  SIII_MA_SVC_ATOMIC_WRITE_EXT_CNF_T  tCnf;
} SIII_MA_SVC_ATOMIC_WRITE_EXT_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_SVC_CMD_ATOMIC_GET_LL_REQ/SIII_MA_SVC_CMD_GET_LL_CNF
 */

/********** request packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_GET_LL_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr; /* Slave address */
  TLR_UINT16 usElem;      /* GetListLen may access 2,4,7 */
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_GET_LL_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_GET_LL_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  SIII_MA_SVC_ATOMIC_GET_LL_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_GET_LL_REQ_T;


/********** confirmation packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ATOMIC_GET_LL_CNF_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr; /* Slave address */
  TLR_UINT16 usSvchError; /* SVC-Error reported from slave (see SERCOS-Spec) */
  TLR_UINT16 usAct_Len;   /* current length of list */
  TLR_UINT16 usMax_Len;   /* maximum length of list */
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_GET_LL_CNF_DATA_T;

/* note: packet length of the GetLL-Cnf:
  on success (no error on reading the first slice): 8 Byte otherwise: 4 */

typedef __TLR_PACKED_PRE struct  SIII_MA_SVC_ATOMIC_GET_LL_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  SIII_MA_SVC_ATOMIC_GET_LL_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_ATOMIC_GET_LL_CNF_T;


/********** packet union **********/
typedef union SIII_MA_SVC_ATOMIC_GET_LL_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_SVC_ATOMIC_GET_LL_REQ_T tReq;
  SIII_MA_SVC_ATOMIC_GET_LL_CNF_T tCnf;
} SIII_MA_SVC_ATOMIC_GET_LL_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_SVC_CMD_MACRO_READ_REQ/SIII_MA_SVC_CMD_MACRO_READ_CNF
 */

/********** request packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_READ_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;   /* Slave address */
  TLR_UINT16 usPriority;    /* 0, 1 */
  TLR_UINT32 ulIDN;         /* EIDN */
  TLR_UINT32 ulAttribute;   /* user may give attribute, otherwise 0! */
  TLR_UINT16 usElem;        /* getDataStatus-1; getName-2; getAttribute-3; getUnit-4; getMin-5; getMax-6; getData-7; */
  TLR_UINT16 usTotalLength; /* user may give len, otherwise 0!; total number of bytes to read or write (if list, including 4 byte header) */
  TLR_UINT16 usIsList;      /* 0, 1, 2, 3 --> See CoSeMa Docu, only relevant for reading data element */
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_READ_REQ_DATA_T;

#define SIII_MA_SVC_MACRO_READ_REQ_SIZE (sizeof (SIII_MA_SVC_MACRO_READ_REQ_DATA_T))

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_READ_REQ_Ttag
{
  TLR_PACKET_HEADER_T                tHead;
  SIII_MA_SVC_MACRO_READ_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_READ_REQ_T;


/********** confirmation packet **********/
/* note: SVC-Steps are 4 byte each */
#define SIII_MA_SVC_MACRO_READ_MAX_PACKET_STEPS (384)
/* variant of macro to have the actual number of bytes per read */
#define SIII_MA_SVC_MACRO_READ_MAX_DATA_BYTES (SIII_MA_SVC_MACRO_READ_MAX_PACKET_STEPS * 4)

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_READ_CNF_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;            /* Slave address */
  TLR_UINT16 usTotalLength;          /* same value in every (segmented) packet */
  TLR_UINT16 usSvchError;            /* SVC-Error reported from slave (see SERCOS-Spec) */
  TLR_UINT16 usOtherRequestCanceled; /* OTHER Request was canceled by us */
#ifdef __SIII_MA_SVC_LEGACY_PACKET_STRUCTURE__
  TLR_UINT16 ausData[SIII_MA_SVC_MACRO_READ_MAX_PACKET_STEPS * 2];
#else
  TLR_UINT8  abData[SIII_MA_SVC_MACRO_READ_MAX_PACKET_STEPS * 4];
#endif
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_READ_CNF_DATA_T;

#define SIII_MA_SVC_MACRO_READ_CNF_EMPTY_SIZE ( 4*sizeof (TLR_UINT16))

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_READ_CNF_Ttag
{
  TLR_PACKET_HEADER_T                tHead;
  SIII_MA_SVC_MACRO_READ_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_READ_CNF_T;


/********** packet union **********/
typedef union SIII_MA_SVC_MACRO_READ_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_SVC_MACRO_READ_REQ_T    tReq;
  SIII_MA_SVC_MACRO_READ_CNF_T    tCnf;
} SIII_MA_SVC_MACRO_READ_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_SVC_CMD_MACRO_READ_EXT_REQ/SIII_MA_SVC_CMD_MACRO_READ_EXT_CNF
 */

/********** request packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_READ_EXT_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;   /* Slave address */
  TLR_UINT16 usPriority;    /* 0, 1 */
  TLR_UINT32 ulIDN;         /* EIDN */
  TLR_UINT32 ulAttribute;   /* user may give attribute, otherwise 0! */
  TLR_UINT16 usElem;        /* getDataStatus-1; getName-2; getAttribute-3; getUnit-4; getMin-5; getMax-6; getData-7; */
  TLR_UINT32 ulTotalLength; /* user may give len, otherwise 0!; total number of bytes to read or write (if list, including 4 byte header) */
  TLR_UINT16 usIsList;      /* 0, 1, 2, 3 --> See CoSeMa Docu, only relevant for reading data element */
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_READ_EXT_REQ_DATA_T;

#define SIII_MA_SVC_MACRO_READ_EXT_REQ_SIZE (sizeof (SIII_MA_SVC_MACRO_READ_EXT_REQ_DATA_T))

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_READ_EXT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  SIII_MA_SVC_MACRO_READ_EXT_REQ_DATA_T tData;
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_READ_EXT_REQ_T;


/********** confirmation packet **********/

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_READ_EXT_CNF_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;            /* Slave address */
  TLR_UINT32 ulTotalLength;          /* same value in every (segmented) packet */
  TLR_UINT16 usSvchError;            /* SVC-Error reported from slave (see SERCOS-Spec) */
  TLR_UINT16 usOtherRequestCanceled; /* OTHER Request was canceled by us */
  TLR_UINT8  abData[SIII_MA_SVC_MACRO_READ_MAX_PACKET_STEPS * 4];
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_READ_EXT_CNF_DATA_T;

#define SIII_MA_SVC_MACRO_READ_EXT_CNF_EMPTY_SIZE ( 3*sizeof (TLR_UINT16)+sizeof(TLR_UINT32))

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_READ_EXT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  SIII_MA_SVC_MACRO_READ_EXT_CNF_DATA_T tData;
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_READ_EXT_CNF_T;


/********** packet union **********/
typedef union SIII_MA_SVC_MACRO_READ_EXT_PCK_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  SIII_MA_SVC_MACRO_READ_EXT_REQ_T  tReq;
  SIII_MA_SVC_MACRO_READ_EXT_CNF_T  tCnf;
} SIII_MA_SVC_MACRO_READ_EXT_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_SVC_CMD_MACRO_WRITE_REQ/SIII_MA_SVC_CMD_WRITE_READ_CNF
 */

/* note: SVC-Steps are 4 byte each */
#define SIII_MA_SVC_MACRO_WRITE_MAX_PACKET_STEPS (384)
/* variant of macro to have the actual number of bytes per read */
#define SIII_MA_SVC_MACRO_WRITE_MAX_DATA_BYTES (SIII_MA_SVC_MACRO_WRITE_MAX_PACKET_STEPS * 4)

/********** request packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_WRITE_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;   /* Slave address */
  TLR_UINT16 usPriority;    /* 0, 1 */
  TLR_UINT32 ulIDN;         /* EIDN */
  TLR_UINT32 ulAttribute;   /* user may give attribute, otherwise 0! */
  TLR_UINT16 usElem;        /* allowed: 1, 7 */
  TLR_UINT16 usTotalLength; /* total number of bytes to read or write (if list, including 4 byte header), length is neccessary if length is > 1 packet */
  TLR_UINT16 usIsList;      /* 0, 1, 2, 3 --> See CoSeMa Docu */
#ifdef __SIII_MA_SVC_LEGACY_PACKET_STRUCTURE__
  TLR_UINT16 ausData[SIII_MA_SVC_MACRO_WRITE_MAX_PACKET_STEPS * 2];
#else
  TLR_UINT8  abData[SIII_MA_SVC_MACRO_WRITE_MAX_PACKET_STEPS * 4];
#endif
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_WRITE_REQ_DATA_T;

#define SIII_MA_SVC_MACRO_WRITE_REQ_EMPTY_SIZE (5*sizeof (TLR_UINT16) + 2*sizeof(TLR_UINT32))

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_WRITE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  SIII_MA_SVC_MACRO_WRITE_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_WRITE_REQ_T;


/********** confirmation packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_WRITE_CNF_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;            /* Slave address */
  TLR_UINT16 usSvchError;            /* SVC-Error reported from slave (see SERCOS-Spec) */
  TLR_UINT16 usOtherRequestCanceled; /* --> OTHER Request was canceled by us */
  TLR_UINT16 usDataStatus;           /* <-- only needed for Write Element 1 ! */
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_WRITE_CNF_DATA_T;

#define SIII_MA_SVC_MACRO_WRITE_CNF_EMPTY_SIZE ( 3 * sizeof(TLR_UINT16) )

#define SIII_MA_SVC_MACRO_WRITE_CNF_SIZE ( sizeof(SIII_MA_SVC_MACRO_WRITE_CNF_DATA_T) )

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_WRITE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  SIII_MA_SVC_MACRO_WRITE_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_WRITE_CNF_T;


/********** packet union **********/
typedef union SIII_MA_SVC_MACRO_WRITE_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_SVC_MACRO_WRITE_REQ_T   tReq;
  SIII_MA_SVC_MACRO_WRITE_CNF_T   tCnf;
} SIII_MA_SVC_MACRO_WRITE_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_SVC_CMD_MACRO_WRITE_EXT_REQ/SIII_MA_SVC_CMD_WRITE_READ_EXT_CNF
 */

/********** request packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_WRITE_EXT_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;   /* Slave address */
  TLR_UINT16 usPriority;    /* 0, 1 */
  TLR_UINT32 ulIDN;         /* EIDN */
  TLR_UINT32 ulAttribute;   /* user may give attribute, otherwise 0! */
  TLR_UINT16 usElem;        /* allowed: 1, 7 */
  TLR_UINT32 ulTotalLength; /* total number of bytes to read or write (if list, including 4 byte header), length is neccessary if length is > 1 packet */
  TLR_UINT16 usIsList;      /* 0, 1, 2, 3 --> See CoSeMa Docu */
  TLR_UINT8  abData[SIII_MA_SVC_MACRO_WRITE_MAX_PACKET_STEPS * 4];
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_WRITE_EXT_REQ_DATA_T;

#define SIII_MA_SVC_MACRO_WRITE_EXT_REQ_EMPTY_SIZE (4*sizeof (TLR_UINT16) + 3*sizeof(TLR_UINT32))

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_WRITE_EXT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_MA_SVC_MACRO_WRITE_EXT_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_WRITE_EXT_REQ_T;


/********** confirmation packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_WRITE_EXT_CNF_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;            /* Slave address */
  TLR_UINT16 usSvchError;            /* SVC-Error reported from slave (see SERCOS-Spec) */
  TLR_UINT16 usOtherRequestCanceled; /* --> OTHER Request was canceled by us */
  TLR_UINT16 usDataStatus;           /* <-- only needed for Write Element 1 ! */
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_WRITE_EXT_CNF_DATA_T;

#define SIII_MA_SVC_MACRO_WRITE_EXT_CNF_EMPTY_SIZE ( 3 * sizeof(TLR_UINT16) )

#define SIII_MA_SVC_MACRO_WRITE_EXT_CNF_SIZE ( sizeof(SIII_MA_SVC_MACRO_WRITE_EXT_CNF_DATA_T) )

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_WRITE_EXT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_MA_SVC_MACRO_WRITE_EXT_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_WRITE_EXT_CNF_T;


/********** packet union **********/
typedef union SIII_MA_SVC_MACRO_WRITE_EXT_PCK_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  SIII_MA_SVC_MACRO_WRITE_EXT_REQ_T tReq;
  SIII_MA_SVC_MACRO_WRITE_EXT_CNF_T tCnf;
} SIII_MA_SVC_MACRO_WRITE_EXT_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_SVC_CMD_MACRO_SET_COMMAND_REQ/SIII_MA_SVC_CMD_MACRO_SET_COMMAND_CNF
 * Packet: SIII_MA_SVC_CMD_MACRO_CLEAR_COMMAND_REQ/SIII_MA_SVC_CMD_MACRO_CLEAR_COMMAND_CNF
 */

/********** request packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_CHANGE_COMMAND_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr; /* Slave address */
  TLR_UINT16 usPriority;  /* 0, 1 */
  TLR_UINT32 ulIDN;       /* EIDN */
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_CHANGE_COMMAND_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_CHANGE_COMMAND_REQ_Ttag
{
  TLR_PACKET_HEADER_T                          tHead;
  SIII_MA_SVC_MACRO_CHANGE_COMMAND_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_CHANGE_COMMAND_REQ_T;


/********** confirmation packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_CHANGE_COMMAND_CNF_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;            /* Slave address */
  TLR_UINT16 usSvchError;            /* SVC-Error reported from slave (see SERCOS-Spec) */
  TLR_UINT16 usAcknowledgement;      /* new command status in the slave */
  TLR_UINT16 usOtherRequestCanceled; /* OTHER Request was canceled by us */
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_CHANGE_COMMAND_CNF_DATA_T;

#define SIII_MA_SVC_MACRO_CHANGE_COMMAND_CNF_SIZE ( sizeof(SIII_MA_SVC_MACRO_CHANGE_COMMAND_CNF_DATA_T) )

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_CHANGE_COMMAND_CNF_Ttag
{
  TLR_PACKET_HEADER_T                          tHead;
  SIII_MA_SVC_MACRO_CHANGE_COMMAND_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_CHANGE_COMMAND_CNF_T;


/********** packet union **********/
typedef union SIII_MA_SVC_MACRO_CHANGE_COMMAND_PCK_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_MA_SVC_MACRO_CHANGE_COMMAND_REQ_T  tReq;
  SIII_MA_SVC_MACRO_CHANGE_COMMAND_CNF_T  tCnf;
} SIII_MA_SVC_MACRO_CHANGE_COMMAND_PCK_T;


/********** typedefs **********/
typedef SIII_MA_SVC_MACRO_CHANGE_COMMAND_REQ_DATA_T SIII_MA_SVC_MACRO_SET_COMMAND_REQ_DATA_T;
typedef SIII_MA_SVC_MACRO_CHANGE_COMMAND_REQ_T SIII_MA_SVC_MACRO_SET_COMMAND_REQ_T;
typedef SIII_MA_SVC_MACRO_CHANGE_COMMAND_CNF_DATA_T SIII_MA_SVC_MACRO_SET_COMMAND_CNF_DATA_T;
typedef SIII_MA_SVC_MACRO_CHANGE_COMMAND_CNF_T SIII_MA_SVC_MACRO_SET_COMMAND_CNF_T;
typedef SIII_MA_SVC_MACRO_CHANGE_COMMAND_PCK_T SIII_MA_SVC_MACRO_SET_COMMAND_PCK_T;

typedef SIII_MA_SVC_MACRO_CHANGE_COMMAND_REQ_DATA_T SIII_MA_SVC_MACRO_CLEAR_COMMAND_REQ_DATA_T;
typedef SIII_MA_SVC_MACRO_CHANGE_COMMAND_REQ_T SIII_MA_SVC_MACRO_CLEAR_COMMAND_REQ_T;
typedef SIII_MA_SVC_MACRO_CHANGE_COMMAND_CNF_DATA_T SIII_MA_SVC_MACRO_CLEAR_COMMAND_CNF_DATA_T;
typedef SIII_MA_SVC_MACRO_CHANGE_COMMAND_CNF_T SIII_MA_SVC_MACRO_CLEAR_COMMAND_CNF_T;
typedef SIII_MA_SVC_MACRO_CHANGE_COMMAND_PCK_T SIII_MA_SVC_MACRO_CLEAR_COMMAND_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_SVC_CMD_MACRO_READ_COMMAND_STATUS_REQ/SIII_MA_SVC_CMD_MACRO_READ_COMMAND_STATUS_CNF
 */

/********** request packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr; /* Slave address */
  TLR_UINT16 usPriority;  /* 0, 1 */
  TLR_UINT32 ulIDN;       /* EIDN */
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_REQ_T;


/********** confirmation packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_CNF_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr;            /* Slave address */
  TLR_UINT16 usSvchError;            /* SVC-Error reported from slave (see SERCOS-Spec) */
  TLR_UINT16 usCommandStatus;        /* the read command status */
  TLR_UINT16 usOtherRequestCanceled; /* OTHER Request was canceled by us */
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_CNF_DATA_T;

#define SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_CNF_SIZE ( sizeof(SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_CNF_DATA_T) )


typedef __TLR_PACKED_PRE struct SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_CNF_T;


/********** packet union **********/
typedef union SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_REQ_T   tReq;
  SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_CNF_T   tCnf;
} SIII_MA_SVC_MACRO_READ_COMMAND_STATUS_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_SVC_CMD_ABORT_ATOMIC_TRANSFER_REQ/SIII_MA_SVC_CMD_ABORT_ATOMIC_TRANSFER_CNF
 * Packet: SIII_MA_SVC_CMD_ABORT_MACRO_TRANSFER_REQ/SIII_MA_SVC_CMD_ABORT_MACRO_TRANSFER_CNF
 *
 * abort (atomic (CoSeMa), macro (CoSeMa) or internal transfer
 */

/********** request packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ABORT_SVC_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr; /* Slave address */
} __TLR_PACKED_POST SIII_MA_SVC_ABORT_SVC_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ABORT_SVC_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  SIII_MA_SVC_ABORT_SVC_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_ABORT_SVC_REQ_T;


/********** confirmation packet **********/
typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ABORT_SVC_CNF_DATA_Ttag
{
  TLR_UINT16 usSlaveAddr; /* Slave address */
} __TLR_PACKED_POST SIII_MA_SVC_ABORT_SVC_CNF_DATA_T;


typedef __TLR_PACKED_PRE struct SIII_MA_SVC_ABORT_SVC_CNF_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  SIII_MA_SVC_ABORT_SVC_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_SVC_ABORT_SVC_CNF_T;


/********** packet union **********/
typedef union SIII_MA_SVC_ABORT_SVC_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_SVC_ABORT_SVC_REQ_T     tReq;
  SIII_MA_SVC_ABORT_SVC_CNF_T     tCnf;
} SIII_MA_SVC_ABORT_SVC_PCK_T;

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__S3M_SVC_PACKET)
#endif


/*************************************************************************************/
#endif /* #ifndef __S3M_SVC_PUBLIC_H */
